package poly.op;

import poly.*;

/**
 * Multiply a polynomial host by a constant NON-ZERO input parameter.
 * @author DXN, SW
 */
public class MulConst implements IPolyOp {

    private IPolyFact _fact;

    public MulConst(IPolyFact f) {
        _fact = f;
    }

    /**
     * @param inp a Double
     */
    public Object constCase(IConstPoly pol, Object... inp) {
        return _fact.makeConstPoly(pol.getLeadCoef() * (Double)inp[0]);
    }

    /**
     * @param inp a Double
     */
    public Object nonConstCase(INCPoly pol, Object... inp) {
        return _fact.makeNCPoly(pol.getLeadCoef() * (Double)inp[0],
                                pol.getOrder(),
                                (IPoly)pol.getLowerPoly().execute(this, inp));
    }
}